# Catch the Grinch

# Modul random einfügen zum Erzeugen von Zufallszahlen
import random

# verschiedene Voreinstellungen
FONT_COLOUR = (255, 255, 255) # Schriftfarbe weiß
WIDTH = 800 # Breite der Spielfläche
HEIGHT = 600 # Höhe der Spielfläche

# Mittelpunktskoordinaten werden berechnet
CENTRE_X = WIDTH // 2 
CENTRE_Y = HEIGHT // 2
CENTRE = (CENTRE_X, CENTRE_Y)

FINAL_LEVEL = 6 # Anzahl der Level
START_SPEED = 10 # Startgeschwindigkeit der Animation
PLAYFIGURES = ["genie", "homer", "jerry", "kermit", "ninja-turtle"] # Namen der Bilder im Ordner images (ohne .png)

# globale Variablen
game_over = False # Spiel durch Fehler beendet?
game_complete = False # Spiel bis zum letzten Level durchgespielt?
current_level = 1 # aktuelles Level
figures = [] # aktuell angezeigte Figuren
animations = [] # Animationen

def draw(): # Löscht alles vom Bildschirm und zeichnet die Figuren neu
    global figures, current_level, game_over, game_complete
    screen.clear() # Bildschirm löschen
    screen.blit("background", (0, 0)) # Hintergrund einfügen
    if game_over: # Wenn die Figuren durchgelaufen sind oder beim Klick auf die falsche Figur:
        display_message("GAME OVER!", "Versuche es erneut.")
    elif game_complete: # Wenn alle Levels geschafft wurden
        display_message("DU HAST GEWONNEN!", "Gut gemacht.")
    else: # sonst Figuren neu zeichnen
        for figur in figures:
            figur.draw()

def update(): # Wenn die Figurenliste leer ist, erzeuge Figuren entsprehend dem Level
    global figures
    if len(figures) == 0:
        figures = make_figures(current_level)

def make_figures(number_of_extra_figures): # Erzeugen von Figuren entsprechend dem Level 
    playfigures_to_create = get_playfigures_to_create(number_of_extra_figures) # Liste der Bilder der Figuren
    new_figures = create_figures(playfigures_to_create) # Liste der Actoren entsprechend der Bilder
    layout_figures(new_figures) # Die Position der Figuren wird auf dem Bildschirm platziert
    animate_figures(new_figures) # Die Figuren werden in Bewegung gesetzt 
    return new_figures

def get_playfigures_to_create(number_of_extra_figures):
    playfigures_to_create = ["grinch"] # Liste mit grinchbild wird erzeugt
    for i in range(0, number_of_extra_figures): # entsprechend dem Level werden zusätzliche Bilder zur Liste hinugefügt 
        random_playfigur = random.choice(PLAYFIGURES)
        playfigures_to_create.append(random_playfigur)
    return playfigures_to_create # Liste wird zurückgegeben

def create_figures(playfigures_to_create): 
    new_figures = [] # leere Liste
    for playfigur in playfigures_to_create: # Für jedes Bild wird der Liste ein Actor hinzugefügt
        figur = Actor(playfigur)
        new_figures.append(figur)
    return new_figures # Die Liste der Actoren wird zurückgegeben


def layout_figures(figures_to_layout):
    number_of_gaps = len(figures_to_layout) + 1 # Anzahl der Lücken wird ermittelt
    gap_size = WIDTH // number_of_gaps # Größe der Lücke wird berechnet
    random.shuffle(figures_to_layout) # Die Figuren werden in der Liste zufällig gemischt
    for index, figur in enumerate(figures_to_layout): # für jede Figur wird die x-Koordinate ermittelt
        new_x_pos = (index + 1) * gap_size
        figur.x = new_x_pos

# Die Figuren werden mit Hilfe der pgzero-Funktion in Bewegung versetzt
# https://pygame-zero.readthedocs.io/en/stable/builtins.html#animations
def animate_figures(figures_to_animate):
    for figur in figures_to_animate:
        duration = START_SPEED - current_level # Geschwindigkeit der Animation
        figur.anchor = ("center", "bottom") # Ausrichtung der Figur festlegen
        # Animation der Figur erzeugen
        # on_finished -> wenn die Figuren durchs Bild gelaufen sind, wird handle_game_over aufgerufen
        # y=HEIGHT Figur bewegt sich in y-Richtung bis zurm unteren Bildrand
        animation = animate(figur, duration=duration, on_finished = handle_game_over, y=HEIGHT)
        # Die Animation wird zur Liste hinzugefügt
        animations.append(animation)

# setzt game_over auf True
def handle_game_over():
    global game_over
    game_over = True


def on_mouse_down(pos):
    global figures, current_level
    for figur in figures:
        if figur.collidepoint(pos):
            # wenn auf den Grinch geklickt wurde wird das nächste Level erzeugt
            if "grinch" in figur.image:
                grinch_figur_click()
            # Wenn auf eine andere Figur geklickt wurde ist das Spiel vorbei
            else:
                handle_game_over()


def grinch_figur_click():
    global current_level, figures, animations, game_complete
    stop_animations(animations)
    # Beim Klick auf den Grinch im höchsten Level ist das Spiel vorbei und man hat gewonnen.
    if current_level == FINAL_LEVEL:
        game_complete = True
    # Beim Klick auf den Grinch werden die Animationen gestoppt, die Listen geleert und das Level erhöht. 
    else:
        current_level = current_level + 1
        figures = []
        animations = []

# Funktion zum Stoppen der Animationen
def stop_animations(animations_to_stop):
    for animation in animations_to_stop:
        if animation.running:
            animation.stop()

# Funktion zum Anzeigen der Bildschirmmeldungen
def display_message(heading_text, sub_heading_text):
    screen.draw.text(heading_text, fontsize=60, center=CENTRE, color=FONT_COLOUR)
    screen.draw.text(sub_heading_text, fontsize=30, center=(CENTRE_X, CENTRE_Y + 30), color=FONT_COLOUR)
    

